# Contributing to NutsDB

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Contributing Documentation
- Contributing a Performance Improvement

By contributing to NutsDB, you agree to abide by the [code of conduct](https://github.com/xujiajun/nutsdb/blob/master/CODE_OF_CONDUCT.md).
 
## Getting Started
If you are looking to contribute to the NutsDB, the best place to start is the [GitHub "issues"](https://github.com/xujiajun/nutsdb/issues) tab. This is also a great place for filing bug reports and making suggestions for ways in which we can improve the code and documentation.

## Reporting bugs

See [reporting bugs](https://github.com/xujiajun/nutsdb/blob/master/.github/ISSUE_TEMPLATE/bug_report.md) for details about reporting any issues.

## Feature request

see [feature request](https://github.com/xujiajun/nutsdb/blob/master/.github/ISSUE_TEMPLATE/feature_request.md) for details about reporting any feature requests.

## Contribution flow

Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Use a Consistent Coding Style

The coding style suggested by the Golang community is used in NutsDB. See the style [doc](https://github.com/golang/go/wiki/CodeReviewComments) for details.

Please follow this style to make NutsDB easy to review, maintain and develop.

## License
By contributing, you agree that your contributions will be licensed under its [Apache License 2.0](https://github.com/xujiajun/nutsdb/blob/master/LICENSE) License.
